
/**
 * 
 */



class EzTemplate {
	
	templateName = null;
	container = null;
	
	
    constructor( container ) {
		let originalContainer = container;
		
		if (typeof container == 'string') {
			this.container = document.getElementById( container );
			
			// not found by id? => try querySelector
			if (!this.container)
				this.container = document.querySelector( container );
		}
		else if (typeof container == 'object' && container.constructor && container.constructor.name == 'jQuery') {
			this.container = container.get(0);
		}
		else {
			this.container = container;
		}
		
        this.reAttributeBinding = /^\[.*\]$/;

        this.reExpressionBinding = /{{(.*?)}}/g;

		this.parentTemplate = null;
		this.parentNode = null;
		

        this.partial = null;
        this.originalNodes = null;

        this.vars = {};

        this.attributeVariables = [];

        this.expressions = [];
        
        this.subTemplates = [];
		
		// this.container not found?
		if (this.container == null) {
			// originalContainer contains a value? => report as error
			if (originalContainer !== null && originalContainer !== undefined) {
				console.error("Container not found", originalContainer);
			}
		}

    }
    
    setTemplateName(n) { this.templateName = n; }
    getTemplateName() { return this.templateName; }
    
    
    static createInstanceSubTemplate( parentTemplate, node, templateHtml ) {
		let sub = new EzTemplate( node );
        
//        sub.tplHtml = templateHtml;
        
        // not used, example for future usage
		sub.setParentTemplate( this );
		sub.setParentNode( node );
        
        sub.setVars( parentTemplate.getVars() );
        
        // set attributes as values
        let attrNames = node.getAttributeNames();
        for(let i in attrNames) {
			let an = attrNames[i];
			let val = node.getAttribute( an );
			
			// binded var?
			if (an.match(sub.reAttributeBinding)) {
//				console.log( 'node', node, an, val );
				an = an.substr(1, an.length-2);
				val = parentTemplate.getVarValue( val );
				sub.setVar(an, val);
			}
			else if (val.match(sub.reExpressionBinding)) {
				val = sub.expressionStringToValue( val );
				sub.setVar( an, val );
			}
			// just set val
			else {
				sub.setVar( an, val );
			}
		}
        
        sub.templateInnerHTML = node.innerHTML;
        
        sub.loadHtml( templateHtml );

        parentTemplate.helper_emptyNode( node );
        
        node.eztemplate = sub;
        
        return sub;
	}
    
    	
	setParentTemplate( t ) { this.parentTemplate = t; }
	setParentNode( n ) { this.parentNode = n; }
	

    setVar(key, val) { this.vars[key] = val; }
    getVars() { return this.vars; }
    setVars(vars) {
		// append/overwrite
		this.vars = Object.assign( this.vars, vars );
	}
	resetVars() { this.vars = {}; }
    
    setObject( prefix, obj ) {
		if (obj === null || obj == undefined) {
			console.error('EzTemplate.setObject(', prefix, ', ', obj, ')');
			return;
		}

		
		let widgetFuncs = {};
		
		// 
		let t = Object.getPrototypeOf(obj);
		let props = Object.getOwnPropertyNames(t);
		
		for(let i in props) {
			let propName = props[i];
			
			if (typeof obj[ propName ] == 'function')
				widgetFuncs[ propName ] = function(evt) { obj[ propName ].bind(obj)(evt, this) };
		}
		
		this.setVar( prefix, widgetFuncs );
	}
    
    
    loadNode(node) {
		if (!node)
			node =  this.container.childNodes;
		
//        console.log(node.constructor.name);
        if (node.constructor && node.constructor.name == 'NodeList') {
            let nl = [];

            node.forEach(function(obj) {
                nl.push(obj.cloneNode(true));
            });

            this.originalNodes = nl;
        }
        else if (Array.isArray(node)) {
            let nl = [];

            for (let i in node) {
                nl.push(node[i].cloneNode(true));
            }

            this.originalNodes = nl;
		}
        else {
            this.originalNodes = [ node.cloneNode(true) ];
        }
        
    }
    
    cloneNode() {
//		console.log('...');
		
		let result = [];
		
		for(let i in this.originalNodes) {
			result.push( this.originalNodes[i].cloneNode(true) );
		}
		
		return result;
	}

    
    loadHtml(html) {
        var s = document.createElement('span');
        s.innerHTML = html;
        
        this.originalNodes = [];
        s.childNodes.forEach(function(obj) {
            this.originalNodes.push(obj.cloneNode(true));
        }.bind(this));

        
//        console.log(s);
//        console.log(this.originalNodes);

    }
    
    parse() {
        if (!this.partial) {
            console.error('template partial not loaded');
            return;
        }
        
        if (this.partial.length == 0) {
            console.error('EzTemplate.parse(): template partial empty. loadNode or loadHtml called?');
            return;
        }
        
        this.attributeVariables = [];
        this.expressions = [];
        this.subTemplates = [];
        
        // TODO: parse..
        if (!this.partial.nodeType) {
            for (var i in this.partial) {
                this._parse(this.partial[i]);
            }
        }
        else {
            this._parse(this.partial);
        }
        
    }
    
    _parse(node) {

        if (this._containsExpression(node)) {
            this.expressions.push(node);
        }
        
        // handle attributes
        if (node.attributes) {
            var l = node.attributes.length;


			let ezforme = node.getAttribute('ez-forme');
			if (ezforme != null) {
//				console.log('jojo', this);
				let sub = EzTemplateFor.createInstance( this, node );
				this.subTemplates.push( sub );
				return;
			}

            for (var i = 0; i < l; i++) {
                var attr = node.attributes.item(i);

                if (!attr.nodeName)
                    continue;


                // ez-for-handling => create partial
                if (attr.nodeName == 'ez-for') {
					let sub = EzTemplateFor.createInstance( this, node );
                    
                    this.subTemplates.push( sub );
                }
                
                // ez-recur
                if (attr.nodeName == 'ez-recur') {
					// check if parent is EzTemplateFor-instance
					if ( ! (this.parentTemplate instanceof EzTemplateFor) ) {
						console.error( 'Error, ez-recur, parent template not an EzTemplateFor-instance', l );
						continue;
					}
					
					// TODO: implement..
				}

				// ez-if-handling => create partial
                if (attr.nodeName == 'ez-if') {
                    let sub = EzTemplateIf.createInstance( this, node );
                    
                    this.subTemplates.push( sub );
                }


                // fill attribute mapping
                if (attr.nodeName.match(this.reAttributeBinding)) {
                    this.attributeVariables.push(attr);
                }

                if (this._containsExpression(attr)) {
                    this.expressions.push(attr);
                }

            }
        }
        
        
        
		// handle ez-template
		if (node.nodeName && node.nodeName.startsWith('EZ-')) {
			EzTemplateLoader.loadTemplate( node.nodeName, function( tpl, opts ) {
				let sub = EzTemplate.createInstanceSubTemplate( this, opts.parentNode, tpl );
                
                this.subTemplates.push( sub );
			}.bind(this), { parentNode: node });
			
			return;
        }
        
        // subtemplate set?
        if (node.attributes && node.getAttribute('ez-subtemplate')) {
			let sub = EzTemplate.createInstanceSubTemplate( this, node, node.innerHTML );
			sub.setTemplateName( node.getAttribute('ez-subtemplate') );
			this.subTemplates.push( sub );
			
			return;
		}
        

        if (node.hasChildNodes) {
            for (let i in node.childNodes) {
                this._parse(node.childNodes[i]);
            }
        }
    }
    
    /**
	 * getVarValue( path ) - get template-var by path, ie: my.var[0].key
	 * 
	 */
    getVarValue(path, opts) {
		
		// TODO: check expression
		if (path.match(this.reExpressionBinding)) {
			return this.execExpression( path, { ref: path } );
		}
		
		// replace array's with dots, items[0].value => items.0.value
		path = path.replace(/\[\s*(\d+)\s*\]/g, '.$1.');	// explode array's
		path = path.replace(/^\./, '');						// remove leading dot
		path = path.replace(/\.$/, '');						// remove ending dot
		path = path.replace(/\.+/g, '.')					// remove double dots
		
		// expode to tokens
        let tokens = path.split('.');

		// lookup
		
        let curVar;
		if (opts && typeof opts.vars != 'undefined') {
			curVar = opts.vars;
		} else {
			curVar = this.vars;
		}
		
//        console.log( path );

        for (let i in tokens) {

            var n = tokens[i];

            let varName = n;
			
			if (typeof curVar[varName] == 'undefined') {
				console.error('EzTemplate.getVarValue, path not found, ', path);
			}


            if (!curVar[varName] && curVar[varName] !== '') {
                return null;
            }
            curVar = curVar[varName];
        }
        
    	return curVar;
    }
    
    setVarValue( vars, path, value ) {
		
		// replace array's with dots, items[0].value => items.0.value
		path = path.replace(/\[\s*(\d+)\s*\]/g, '.$1.');	// explode array's
		path = path.replace(/^\./, '');						// remove leading dot
		path = path.replace(/\.$/, '');						// remove ending dot
		path = path.replace(/\.+/g, '.')						// remove double dots
		
//		console.log(path);
		
		let tokens = path.split('.');
//		console.log( tokens );
		
    	let subvar = vars;
    	
    	for(let i=0; i < tokens.length; i++) {
			let t = tokens[i];
			
			if (i == tokens.length -1)
				subvar[t] = value;
			else if (!subvar[ t ])
				subvar[ t ] = {};
			subvar = subvar[ t ];
		}
		
		return vars;
	}
    
    /**
	 * applyVars() - apply's attribute binding to [attr-name]-attributes
	 * 
	 */
    applyVars() {
		
        for (var i in this.attributeVariables) {
            var att = this.attributeVariables[i];

            // get varname
            var attrName = att.nodeName;
            attrName = attrName.substr(1);
            attrName = attrName.substr(0, attrName.length - 1);

            var varName = att.value;
            
            
            // get value
            var v = this.getVarValue(varName);
            
            // null? => show empty string
            if (v === null) {
//				console.log(att.ownerElement, 'var not found', varName);
            	v = '';
        	}

			att.ownerElement.ezTpl = this;
			
			// contenthtml? => insert html, can break stuff..
			if (attrName == 'contenthtml') {
				this.helper_emptyNode( att.ownerElement );
				att.ownerElement.innerHTML = v;
			}
			// text? => insert as text-node (escapes special chars)
			else if (attrName == 'contenttext') {
				this.helper_emptyNode( att.ownerElement );
				att.ownerElement.appendChild( document.createTextNode(v) );
			}
			else if (attrName == 'checked') {
				if (v) {
					att.ownerElement.checked = true;
				}
			}
			else if (attrName == 'selected') {
				if (v) {
					att.ownerElement.selected = true;
				}
			}
            // set attribute
			else {
				if (attrName.indexOf('data-') === 0) {
					att.ownerElement[attrName.substr(5)] = v;
				} else {
					if (typeof v == 'function' || typeof v == 'object') {
						att.ownerElement[attrName] = v;
					}
					else {
						
						let owner = att.ownerElement;

						owner.setAttribute(attrName, v);

						// special case..
						if (owner.nodeName == 'SELECT') {
							owner.value = v;
						}
						att.ownerElement.setAttribute(attrName, v);
						att.ownerElement.setAttribute(attrName, v);

//						if (attrName == 'onclick' || attrName == 'onchange') {
//							att.ownerElement[attrName] = function() { eval( att.value ); };
//						}
//						else {
//							att.ownerElement.setAttribute(attrName, v);
//						}
					}
				}
        	}
            
            // eztemplate? => set var
            if (att.ownerElement.eztemplate) {
				att.ownerElement.eztemplate.setVar( attrName, v );
			}
        }
    }
    
    /**
	 * applyExpression() - apply's {{ }}-expressions
	 */
    applyExpressions() {
//        console.log(this.expressions);
        for (let i in this.expressions) {
            let o = this.expressions[i];
            
	
	        let v = this.expressionStringToValue( o.nodeValue, {ref: o.ownerElement} );
	
            o.nodeValue = v;
        }
    }
    
    expressionStringToValue( val, opts ) {
        if (typeof val != 'string')
            return val;
        
        let matches = val.match(this.reExpressionBinding);
        
        if (matches) {

            for (let matchNo in matches) {
                let result = this.execExpression(matches[matchNo], opts);

                val = val.replaceAll(matches[matchNo], result);
            }

        }
        
        return val;
	}
    
    
    /**
	 * _containsExpression() - checks if nodeValue contains an {{ }}-expression
	 */
    _containsExpression(node) {
		if (node && node.nodeValue) {
			var v = node.nodeValue;

            if (v.match(this.reExpressionBinding))
                return true;
		}
		
		return false;
    }
    
    /**
	 * execExpression() - execute's {{ }}-expression
	 */
    execExpression(code, opts) {

        // remove {{ }}
        if (code.startsWith('{{')) {
            code = code.substr(2);
            code = code.substr(0, code.length - 2);
        }

        // code for importing tpl_vars
        let js_tplvars = '';
        for (let v in this.vars) {
			if (v == 'class') continue;
			
            if (typeof v == 'string' && v.match(/^[a-zA-Z_]+$/)) {
//                js_tplvars += 'let ' + v + ' = ' + JSON.stringify(this.vars[v]) + ';\n';
                js_tplvars += 'let ' + v + ' = this.vars[\'' + v + '\'];\n';
            }
        }

        // build js
        code = js_tplvars + "\n\n return " + code + ';';


        // console.log( code );
        let result='';
        
        // exec
        try {
            result = eval('(function() { ' + code + ' }.bind( this ))');
            result = result();
        }
        catch (err) {
//            result = null;//'Error: ' + err.message;
            console.error('EzTemplate.execExpression error', err);
            
            if (opts && opts.ref)
                console.error(opts.ref, 'Code: ' + code);
            else
                console.error('Code: ' + code);
        }

        return result;
    }
    
    
    applySubtemplates() {
		
//		 console.log( this.subTemplates );
		
		for(let i in this.subTemplates) {
			this.subTemplates[i].reset();
			this.subTemplates[i].render();
		}
		
	}

    
    
    helper_emptyNode( node ) {
		while (node && node.hasChildNodes() ) {
			node.removeChild( node.childNodes[0] );
		}
	}
    
    
    serializeVars( opts ) {
		
		opts = opts ? opts : {};
		
		let container = opts.container ? opts.container : this.container;
		
        // TODO: get vars from dom
        let r = {};
        
        this._serializeVars( container, r );
		
		return r;
    }
    
	serializeAsArray( varPath ) {
		if (!varPath) {
			console.error('no varPath');
			return;
		}
		
		let vars = this.serializeVars();
		
//		console.log('hmz',vars);
		let value = this.getVarValue( varPath, { vars: vars } );
		
		// not found?
		if (!value)
			return [];
		
		// cast 2 array
		let arr = [];
//		console.log('woopwoop', value);
		for(let key in value) {
			arr.push( value[key] );
		}
		
		return arr;
	}
    
    _serializeVars( container, vars, opts ) {
		
		for(let i in container.childNodes) {
			let node = container.childNodes[i];
//			console.log( node );

			if (node.nodeName == 'INPUT' || node.nodeName == 'TEXTAREA') {
				
				// set node.value
				if (node.name) {
					this.setVarValue( vars, node.name, node.value );
				}
				
				
				let l = node.attributes.length;
	            for (var ac = 0; ac < l; ac++) {
	                let att = node.attributes.item(ac);
	                
	                if ( ! att.nodeName.match( this.reAttributeBinding ) )
	                	continue;
	            	
	                // get varname
	            	let  attrName = att.nodeName;
	            	attrName = attrName.substr(1);
	            	attrName = attrName.substr(0, attrName.length - 1);
	            	
	            	
	            	let varname = att.value;
	            	
	
					if (attrName == 'contenthtml') {
						this.setVarValue( vars, varname, node.innerHTML );
					}
					else if (attrName == 'contenttext') {
						this.setVarValue( vars, varname, node.textContent );
					}
					else if (attrName == 'value') {
//						console.log(varname);
						this.setVarValue( vars, varname, node.value );
					}
	            }
            }
			
			
			if (node.childNodes && node.childNodes.length > 0) {
				let tpl = node.eztemplate ? node.eztemplate : this;
				
				let sv = tpl._serializeVars(node, vars);
				
				// ez-for? => set in var
				// else merge
				for(let v in sv) {
					vars[v] = sv[v];
				}
			}
		}
		
		return vars;
	}
    
    
	reset() {
	}
	
	
	checkTemplatesLoaded(callback) {
		// check if all templates are loaded, if not, wait
		if (EzTemplateLoader.xhrCounter > 0) {
			EzTemplateLoader.clearCallbackXhrFinished();
			
			EzTemplateLoader.addCallbackXhrFinished(function() {
				if (EzTemplateLoader.xhrCounter == 0) {
					callback();
				}
			}.bind(this));
			return false;
		}
		
		return true;
	}

    
    build( opts ) {
		
		this.partial = this.cloneNode();
	
        this.parse();
        
        // check if templates are loaded
        let r = this.checkTemplatesLoaded(function() {
			if (opts && opts.update_on_templates_loaded) {
				this.render();
			}
			// rebuild
			else {
				this.build();
			}
        }.bind(this) );
        
        // templates not loaded? => wait for callback
        if (!r) {
			return false;
		}

		// apply's []-attributes
		this.applyVars();
        
        // apply's {{ }}-vars
        this.applyExpressions();
        
        // ez-for, ez-if, ...
        this.applySubtemplates();

        return this.partial;
    }
    
    isTopTemplate() {
		if (!this.parentTemplate)
			return true;
		else
			return false;
	}
	
	
	renderSubTemplate( subTemplateName, vars ) {
		
		for(var i in this.subTemplates) {
			if (this.subTemplates[i].getTemplateName() == subTemplateName) {
				console.log( this.subTemplates[i].isTopTemplate() );
				this.subTemplates[i].setVars( vars ? vars : this.vars );
				this.subTemplates[i].render();
			}
		}
		
		
	}
    
    render( ) {
		
		// loadNode() & loadHtml not called? => lets go
		if (this.isTopTemplate() && !this.originalNodes) {
			this.loadNode();
		}
	
		// build it
		let nodes = this.build( { update_on_templates_loaded: true });
		
		// false? => templates not yet loaded
		if (nodes === false) {
			return;
		}
		
		var c = this.container;
		
		this.helper_emptyNode( c );
		
		// set nodes
		for(let i in nodes) {
			c.appendChild( nodes[i] );
		}
		
		
		if (c) {
			let scripts = c.querySelectorAll('script');
			if ( scripts.length ) {
				this.container.ezTemplate = this;
//				console.log( c );
				for(let i=0; i < scripts.length; i++) {
					let sc = scripts.item(i);
					if (sc.executed)
						continue;
					
					
					let parentNode = sc.parentNode;
					parentNode.removeChild( sc );
					
					// inject variables
					let scriptText = '';
					let varNames = Object.getOwnPropertyNames( this.vars );
					for(let i in varNames) {
						let v = this.expressionStringToValue( this.vars[varNames[i]], { ref: sc } );
						
						let vn = varNames[i];
						vn = vn.replace('-', '');
						
						// skip reserved keywords
						if (vn == 'class') continue;
						
						scriptText += 'let ' + vn + ' = ' + JSON.stringify( v ) + ';\n';
					}
					scriptText += sc.innerHTML;
					
					// insert script to execute
					let script = document.createElement('script');
					scriptText = '(function() { ' + scriptText + ' })();';
					script.innerHTML = scriptText;
					
					parentNode.appendChild(script);
					script.executed = true;
				}
			}
		}
		
		
		
		// trigger EzTemplate.updated-event for top template
		if (this.isTopTemplate()) {
			let evt = new Event('EzTemplate.updated');
			window.dispatchEvent( evt );
		}
	}
}








class EzTemplateFor extends EzTemplate {
	
	ezForMe = false;
	loopVar = null;
	ezForMeParent = null;
	
	loopName = null;
	
	static forCounter = 1;
	
	constructor() {
		super();
		
		this.loopName = 'ez-for-' + (EzTemplateFor.forCounter++);
		
		this.counter = 0;
		this.items = [];
		
		this.nameItem = null;
		this.nameKey = null;
		this.nameCounter = null;
		
		this.originalNodes = [];
		
	}
	
	static createInstance( parentTemplate, node ) {
		let sub = new EzTemplateFor();
		
//		let arrayItem = node.attributes['ez-for'].value;
		
		if (node.getAttribute('ez-forme')) {
			sub.ezForMe = true;
			sub.loopVar = node.getAttribute('ez-forme');
//			sub.beforeNode = node.nextSibling;
			sub.ezForMeParent = node.parentNode;
			
			node.removeAttribute('ez-forme');
		}
		else {
			sub.ezForMe = false;
			sub.loopVar = node.getAttribute('ez-for');
		}
		
		
		sub.setParentTemplate( parentTemplate );
		sub.setVars( parentTemplate.getVars() );
		
		if (sub.ezForMe) {
			sub.setParentNode( node );
			sub.loadNode( node );
		}
		else {
			sub.setParentNode( node );
			sub.loadNode( node.childNodes );
		}

//        if ( node.attributes['ez-item'] ) {
//            sub.setVar(node.attributes['ez-item'], parentTemplate.getVarValue(arrayItem));
//        }
        
        // empty node, rendering by EzTemplateFor
        parentTemplate.helper_emptyNode( node );
        
        node.eztemplate = sub;
        
        return sub;
	}
	
	reset() {
		this.helper_emptyNode( this.parentNode );
		this.counter = 0;
	}
	
	loadNode(node) {
//        console.log(node.constructor.name);
        
        this.originalNodes = [];
        
        if (node.constructor.name == 'NodeList') {
            node.forEach(function(obj) {
                this.originalNodes.push(obj.cloneNode(true));
            }.bind(this));
        }
        else {
			this.originalNodes.push( node.cloneNode(true) );
        }
        
//        console.log( this.originalNodes );
    }
    
    _resetPartial() {
		let l = [];
		
		for(let i in this.originalNodes) {
			l.push( this.originalNodes[i].cloneNode(true) );
		}
		
		this.partial = l;
	}
	
	
    _serializeVars( container, vars, opts ) {
		opts = opts ? opts : {};
		
//		console.log( container );
		
		// ez-for="..."-value
//		let nameItemsCollection = null;
//		if ( this.parentNode.attributes['ez-for'] )
//			nameItemsCollection = this.parentNode.attributes['ez-for'].value;
//		
		
		// not found/set? => skip
		if (!this.loopVar) {
			console.error( 'Error: EzTemplateFor._serializeVars, ez-for=value not found');
			return vars;
		}
		
		
		if (typeof opts.itemCounter == 'undefined')
			opts.itemCounter = -1;
		
		for(let i in container.childNodes) {
			let node = container.childNodes[i];
			
			// check if node._itemCounter is set. Items are added in order, so last _itemCounter is the valid one
			if (typeof node._itemCounter != 'undefined')
				opts.itemCounter = node._itemCounter;
			
			
			if (opts.itemCounter >= 0 && (node.nodeName == 'INPUT' || node.nodeName == 'TEXTAREA')) {
				let l = node.attributes.length;
	            for (var ac = 0; ac < l; ac++) {
	                let att = node.attributes.item(ac);
	                
	                if ( ! att.nodeName.match( this.reAttributeBinding ) )
	                	continue;
	            	
	                // get varname
	            	let  attrName = att.nodeName;
	            	attrName = attrName.substr(1);
	            	attrName = attrName.substr(0, attrName.length - 1);
	            	
	            	// determine path => replace 'ez-item'-prefix by ez-for="name[<counter>]"
	            	let prefix = '';
	            	let varName = att.nodeValue;
	            	if (att.nodeValue.startsWith( this.nameItem + '.' )) {
	            		prefix = this.nameItem + '.';
	            		varName = varName.substr( prefix.length );
            		}
	            	let varPath = this.loopVar + '['+opts.itemCounter+'].' + varName;
	            	
	            	
					if (attrName == 'contenthtml') {
						this.setVarValue( vars, varPath, node.innerHTML );
					}
					else if (attrName == 'contenttext') {
						// TODO..
						this.setVarValue( vars, varPath, node.textContent );
					}
					else if (attrName == 'value') {
//						console.log(varPath);
						this.setVarValue( vars, varPath, node.value );
					}
	            }
            }
			
			
			if (node.childNodes && node.childNodes.length > 0) {
				
				let sv = this._serializeVars(node, vars, opts);
				
				// ez-for? => set in var
				// else merge
				for(let v in sv) {
					vars[v] = sv[v];
				}
			}
		}
		
		return vars;
	}
    
    
    
    updateRecord( oldRow, newRecord ) {
		
		let t = this.createRecord( newRecord, {
			insertBeforeNode: oldRow
		} );
		
		$(oldRow).remove();
		
	}
    
    
    /**
	 * record - the record
	 * opts.iteratorKey..
	 */
    createRecord( record, opts ) {
		if (!record)
			record = {};
		
		let t = new EzTemplate( );
		
		t.setParentNode( this.parentNode );
		t.setParentTemplate( this );
		
		t.setVars( this.vars );
		
		if (this.nameItem) {
			t.setVar( this.nameItem, record );
		}
		if (this.nameCounter) {
			t.setVar( this.nameCounter, this.counter );
		}
		if (this.nameKey) {
			t.setVar( this.nameKey, opts.iteratorKey );
		}
		
		let cn = this.cloneNode();
		t.loadNode( cn );
		
//		console.log('nodes', this.originalNodes);
//		return;
		
//		t.parse();
//		t.applyVars();
//		t.applyExpressions();
		
		let nodes = t.build();
		
		for(let i in nodes) {
			nodes[i]._itemCounter = this.counter;
			
			
			// ez-forme=".." loop?
			if (this.ezForMe) {
				$(nodes[i]).attr( 'ez-loop-name', this.loopName );

				let pn = this.parentNode.parentNode;
				console.log('pn', this.parentNode);
				
				let lastItem = $(pn).find('[ez-loop-name="' + this.loopName + '"]').last();
				
				if (lastItem.length > 0) {
					lastItem = lastItem.get(0).nextSibling;
				} else {
					lastItem = this.parentNode.nextSibling;
				}
				
				pn.insertBefore( nodes[i], lastItem );
			}
			// ez-for=".." loop?
			else {
				if (opts && opts.insertBeforeNode) {
					this.parentNode.insertBefore( nodes[i], opts.insertBeforeNode );
				}
				else {
					this.parentNode.appendChild(nodes[i]);
				}
			}
		}
		
		this.subTemplates.push( t );
    
		this.counter++;
		
		this.checkNoResults();
		
		return t;
	}
	
    build() {
		
		this.items = this.parentTemplate.getVarValue( this.loopVar );
		if ( this.parentNode.attributes['ez-item'] )
			this.nameItem    = this.parentNode.attributes['ez-item'].nodeValue;
		
		if ( this.parentNode.attributes['ez-key'] )
			this.nameKey     = this.parentNode.attributes['ez-key'].nodeValue;
		
		if ( this.parentNode.attributes['ez-counter'] )
			this.nameCounter = this.parentNode.attributes['ez-counter'].nodeValue;
		
		
		for(let i in this.items) {
			
			this.createRecord( this.items[i], { iteratorKey: i } );
		}
		
		this.checkNoResults();
    }
    
    checkNoResults() {
		let tbl = $(this.parentNode).closest('table');
		
		let records = tbl.find( 'tr' );
		
		if (records.length > 2) {
			tbl.find('tbody.no-results').addClass('hidden');
		}
		else {
			tbl.find('tbody.no-results').removeClass('hidden');
		}
	}
}


class EzTemplateIf extends EzTemplate {

	constructor() {
		super();
		
		
	}
	
	
	static createInstance(parentTemplate, node) {
		let sub = new EzTemplateIf();
                    
        sub.setParentTemplate( parentTemplate );
        sub.setParentNode( node );
        
        sub.setVars( parentTemplate.getVars() );
        
        sub.loadNode( node.childNodes );
        
        // empty node, rendering by EzTemplateIf
        parentTemplate.helper_emptyNode( node );
        
        node.eztemplate = sub;
        
        return sub;
	}
	
	
	build() {
		this.partial = this.cloneNode();
		
		let jscode = this.parentNode.attributes['ez-if'].nodeValue;
		
		let r = this.execExpression( '{{'+jscode+'}}', { ref: this.parentNode } );
		
		if (r === '1' || r === 1) {
			r = true;
		}
		
//		console.log(r, jscode, this.vars);
		if (r === true) {
//			console.log( this.originalNodes );
			$(this.parentNode).removeClass('hidden');
			
			if (this.parentNode.hasChildNodes() == false) {
				this.partial = this.originalNodes;
				let c = super.build();
				for(let i in c) {
					this.parentNode.appendChild(c[i]);
				}
			}
		}
		else {
			// false? => hide
			this.helper_emptyNode( this.parentNode );
			$(this.parentNode).addClass('hidden');
		}
	}
}




