<?php

namespace customer\forms;

use customer\service\CompanyService;
use core\ObjectContainer;
use core\forms\DynamicSelectField;

class CompanySelectWidget extends DynamicSelectField {
    
    protected $customerDeleted = false;
    

    public function __construct($name='customer_id', $defaultValue=null, $defaultText=null, $endpoint=null, $label=null) {
        
        if ($defaultText == null) $defaultText = t('Make your choice');
        if ($endpoint == null) $endpoint = '/?m=customer&c=customer&a=select2&customer_type=company';
        if ($label == null) $label = t('Customer');
        
        parent::__construct($name, $defaultValue, $defaultText, $endpoint, $label);
        
        // these are necessary in the popup when clicked on the '+'-anchor
        hook_htmlscriptloader_enableGroup('iban');
        hook_htmlscriptloader_enableGroup('select-company-list-edit');
//         hook_htmlscriptloader_enableGroup('select-person-list-edit');
        
        // 
        hook_htmlscriptloader_enableGroup('customer-select-widget');
    }
    
    
    public function bindObject($obj) {
        parent::bindObject($obj);
        
        $companyId = null;
        $this->customerDeleted = false;
        
        if (is_object($obj) && method_exists($obj, 'getCompanyId')) {
            $companyId = $obj->getCompanyId();
        }
        
        
        if (is_array($obj) && isset($obj[$this->getName()])) {
            $val = $obj[$this->getName()];
            
            if (strpos($val, 'company-') === 0) {
                $companyId = str_replace('company-', '', $val);
            }
        }
        
        if ($companyId) {
            $this->setValue('company-'.$companyId);
            
            $cs = ObjectContainer::getInstance()->get(CompanyService::class);
            $company = $cs->readCompany($companyId, ['record-only' => true]);
            
            if ($company == null || $company->getDeleted()) {
                $this->customerDeleted = true;
            }
            if ($company) {
                $this->setDefaultText( $company->getCompanyName() );
            }
            else {
                $this->setDefaultText( 'company-'.$companyId );
            }
        } else {
            $this->setDefaultText( t('Make your choice') );
        }
    }
    
    
    
    public function fill($obj, $fields=array()) {
        $v = $this->getValue();
        
        if (method_exists($obj, 'setCompanyId')) {
            $obj->setCompanyId(0);
            if (strpos($v, 'company-') === 0) {
                $obj->setCompanyId( str_replace('company-', '', $v) );
            }
        }
        
    }
    
    
    
    public function render() {
        if ($this->customerDeleted) {
            $this->addContainerClass('customer-deleted');
        }
        
        $html = parent::render();
        
        $i = '';
        if (hasCapability('customer', 'edit'))
            $i = ' <a href="javascript:void(0);" onclick="newCustomerPopup_Click( this, {customer_type: \'company\'} );" class="fa fa-plus"></a>';
        
        $html = str_replace('</select>', '</select>'.$i, $html);
        
        return $html;
    }
    
    
    
}


