<?php

namespace core\export;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use core\forms\lists\ListResponse;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use core\db\DBObject;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class BaseExportExcel extends BaseExport {
    

    
    public function xlsHeader($sheet, $headers, $rowno=1) {
        for($x=0; $x < count($headers); $x++) {
            $sheet->setCellValue($this->colCode($rowno, $x+1), $headers[$x]);
        }
    }
    
    public function xlsCol($sheet, $rowno, $colno, $val, $field='text') {
        
        switch($field) {
            case 'datetime' :
                if (valid_datetime($val)) {
                    $val = Date::PHPToExcel($val);
                    $sheet->setCellValue($this->colCode($rowno, $colno), $val);
                    
                    $sheet->getStyle($this->colCode($rowno, $colno))->getNumberFormat()->setFormatCode('dd-mm-yyyy hh:mm:ss');
                }
                break;
            case 'date' :
                if (valid_date($val)) {
                    $val = Date::PHPToExcel($val);
                    $sheet->setCellValue($this->colCode($rowno, $colno), $val);
                    
                    $sheet->getStyle($this->colCode($rowno, $colno))->getNumberFormat()->setFormatCode('dd-mm-yyyy');
                }
                break;
            case 'bool' :
            case 'boolean' :
                $sheet->setCellValueExplicit($this->colCode($rowno, $colno), $val ? true : false, DataType::TYPE_BOOL);
                
                break;
            case 'numeric' :
                $sheet->setCellValueExplicit($this->colCode($rowno, $colno), $val, DataType::TYPE_NUMERIC);
                
                break;
            case 'formula' :
                $sheet->setCellValueExplicit($this->colCode($rowno, $colno), $val, DataType::TYPE_FORMULA);
                
                break;
            case 'euro' :
            case 'currency' :
                $colpos = $this->colCode($rowno, $colno);
                $sheet->getStyle($colpos)->getNumberFormat()->setFormatCode( '"€" #,##0.00_-' );
                $sheet->setCellValue( $colpos, $val );
                
                break;
            default :
                $sheet->setCellValue($this->colCode($rowno, $colno), $val);
        }
    }
    
    
    public function colCode($rowno, $colno) {
        return $this->colChar($colno).$rowno;
    }
    
    public function colChar($no) {
        $str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        
        $no = $no-1;
        
        $char = '';
        
        if ($no >= strlen($str)) {
            $no2 = ($no-($no%strlen($str))) / strlen($str);
            
            $char .= $str[ $no2-1 ];
        }
        
        $char = $char . $str[ ($no%26) ];
        
        return $char;
        
    }
    
    public function outputExcel(Spreadsheet $spreadsheet, $filename) {
        
        if (ctx()->getVar('list-response-excel-disable-headers')) {
            
        } else if (is_web()) {
            
            if (endsiWith($filename, '.xls') == false && endsiWith( $filename, '.xlsx') == false) {
                $filename = $filename . '.xlsx';
            }
            
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="'.$filename.'"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
        }
        
        $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
        $writer->save('php://output');
    }
    
}

