<?php


namespace core\cron;

abstract class CronJobBase {
    
    protected $title = null;
    
    protected $daily = false;
    protected $timeout = null;                  // timeout in seconds before next run
    
    protected $autoHandleDbTransaction = true;
    
    protected $forceStartAllowed = true;
    
    
    // isDaily set? => run CronJobBase daily
    public function isDaily() { return $this->daily; }
    
    // timeout set? => check if "timeout"-seconds is elapsed since last run
    public function getTimeout() { return $this->timeout; }
    
    public function isForceStartAllowed() { return $this->forceStartAllowed; }
    
    
    // can be overridden for custom business-rules
    public function checkJob() { return false; }
    
    public function getTitle() { return $this->title; }
    
    public function getMessage() { return ''; }
    public function getError() { return ''; }
    public function getStatus() { return ''; }
    
    /**
     * setAutoHandleDbTransaction()
     *  - non-daily CronJobs, execute job within a db-transaction?
     *  - daily CronJob's always have to handle their own transactinos
     * 
     * TVW: bit mixed feelings about this..
     */
    public function setAutoHandleDbTransaction($bln) { $this->autoHandleDbTransaction = $bln ? true : false; }
    public function autoHandleDbTransaction() { return $this->autoHandleDbTransaction; }
    
    
    
    public abstract function run();
    
}

